# -*- coding: utf-8 -*-
# utf-8 wegen Umlaute
from gamegrid import *
import time # Verwendung der timer-Bibliothek


# ---------------- class Timer ----------------
# Konstruktor bekommt die Dauer in Sekunden, die der Timer herunterzählt. Countdown-Timer.
# es ist natürlich auch eine Stoppuhr (aufwärtszählen) denkbar.
# 
class Timer(Actor): # wichtig: Timer ist hier ein Actor (Vererbung).
    # Dessen act-Methode wird vom GameGrid-System periodisch augerufen (vgl. FootBall.py). Deshalb können wir den Ablauf der Zeit überprüfen.
    
    def __init__(self, dauer): # dauer in sekunden
        self.dauer = dauer
        self.startTime = time.clock()
        self.oldTime = self.startTime
        
    def act(self):
        now = time.clock()
        if now - self.oldTime >1 :
            self.oldTime = now
            self.dauer = self.dauer -1
            #print self.dauer
            self.anzeige.zeigeTimer(self.dauer)
            
    
    def addAnzeige(self,anzeige): # hiermit geben wir Timer die Möglichkeit Nachrichten auszugeben, ein Anzeige-Objekt wird dem Timer bekannt gemacht ("hat" - Assoziation)
        self.anzeige = anzeige    
                    
    def checkRunning(self):
        if self.dauer <=0 : # wenn die Zeit abgelaufen ist, dann gibt diese Methode FALSE zurück = Timer läuft nicht mehr
            return False
        return True